--[[
	Bongos Minimap
		options menu
--]]

local Bongos = LibStub('AceAddon-3.0'):GetAddon('Bongos3')
local L = LibStub('AceLocale-3.0'):GetLocale('Bongos3-Minimap')

function BongosMinimap:CreateMenu()

	local menu = Bongos.Menu:Create(self.id)
	local panel = menu:AddLayoutPanel()
	
	local showNorth = panel:CreateCheckButton(L.ShowNorth)
	showNorth:SetScript("OnShow", function(b) b:SetChecked(self.sets.showNorth) end)
	showNorth:SetScript("OnClick", function(b) self:ToggleNorth(b:GetChecked()) end)
	
	local borderColor = self:CreateColorPicker(L.BorderColor, panel, "SetBorderColor", self.sets.borderColor)
	borderColor.tooltipText = L.HideBorderTip
		
	--borders tab
	local panel = self:CreateList(L.Border, 'border', menu, function(v)
		self:SetBorderSkin(v)
	end)
	
	self:Sort(self.skins, function(name)
		panel:AddItem(name)
	end)

	--shapes tab
	local panel = self:CreateList(L.Shape, 'mask', menu, function(v)
		self:SetMask(v)
		self:SetBorderSkin(self.sets.border)
	end)
	
	for _,required in pairs({4, 0, 1, 2, 3}) do
		self:Sort(self.Shapes, function(name, sides)
			local count = 0
			for i = 1,4 do
				if sides[i] then count = count + 1 end
			end
			
			if count == required then
				panel:AddItem(name, name:gsub('RIGHT', ' %1'):gsub('LEFT', ' %1'))
			end
		end)
	end

	--buttons tab
	local panel = menu:AddPanel(L.Buttons)
	panel.CreateButtonToggle = function(...) return self:CreateButtonToggle(...) end
	
	local lockButtons = panel:CreateCheckButton(L.LockButtons)
	lockButtons:SetScript("OnShow", function(b) b:SetChecked(self.sets.lockButtons) end)
	lockButtons:SetScript("OnClick", function(b) self.sets.lockButtons = b:GetChecked() end)
	
	local stickyButtons = panel:CreateCheckButton(L.StickyButtons)
	stickyButtons:SetScript("OnShow", function(b) b:SetChecked(self.sets.stickyButtons) end)
	stickyButtons:SetScript("OnClick", function(b) self.sets.stickyButtons = b:GetChecked() end)

	panel:CreateButtonToggle("Map")
	panel:CreateButtonToggle("Day")
	panel:CreateButtonToggle("Zoom")
	panel:CreateButtonToggle("Mail")
	panel:CreateButtonToggle("Battle")
	
	local showTracker = panel:CreateButtonToggle("Tracker")
	showTracker.tooltipText = L.ChooseTrackingTip
	
	panel:CreateButtonToggle("Voice")
	
	return menu
end


--[[ List ]]--

function BongosMinimap:CreateList(name, arg, menu, func)
	local panel = menu:AddPanel(name)
	panel.height = panel.height + 10
	panel.numItems = 0

	panel.get = function(v) return self.sets[arg] == v end
	panel.AddItem = self.AddListItem
	panel.set = func
	
	return panel
end

function BongosMinimap:AddListItem(value, name)
		
	self.numItems = self.numItems + 1
	self.height = self.height + 18

	local button = CreateFrame("Button", nil, self)
	button:SetWidth(155) button:SetHeight(18)
	button:SetPoint("TOPLEFT", self, "TOPLEFT", 8, 15 - 18 * self.numItems)
	
	name = name or value
	name = strlower(name)
	name = name:gsub('(%w+)-(%w+)', "%1 - %2")
	name = name:gsub('%w+', function(s) return s:gsub('^%l', strupper) end)
	
	local text = button:CreateFontString()
	text:SetPoint("LEFT", button, "LEFT", 0, 0)
	text:SetFontObject("GameFontNormal")
	text:SetJustifyH("LEFT")
	text:SetText(name)
	button:SetFontString(text)
	
	local highlight = button:CreateTexture()
	highlight:SetAllPoints(button)
	highlight:SetTexture("Interface/QuestFrame/UI-QuestTitleHighlight")
	button:SetHighlightTexture(highlight)
	
	button:SetScript("OnClick", function()
		self.set(value)
	end)
		
	button:SetScript("OnUpdate", function()
		if self.get(value) then
			button:SetTextColor(0.2, 1, 0.2)
			button:SetHighlightTextColor(0.2, 1, 0.2)
		else
			button:SetTextColor(1, 0.82, 0)
			button:SetHighlightTextColor(1, 1, 1)
		end
	end)
end

function BongosMinimap:Sort(table, func) --sorts a table by alphabetic order
	local t = {}
	for string, value in pairs(table) do
		local pos
		
		for i, comp in pairs(t) do
			if strlower(string) < strlower(comp) then
				pos = i
				break
			end
		end
		tinsert(t, pos or #t + 1, string)
	end
	for _,key in pairs(t) do
		func(key, table[key])
	end
end


--[[ Color Picker ]]--

function BongosMinimap:CreateColorPicker(name, panel, func, color)
	local f = panel:CreateCheckButton(name)
	f:SetScript("OnClick", self.ColorPickerOnClick)
	f.func = function(...) self[func](self, ...) end
	f.SetColor = self.SetColor
	
	local bg = f:CreateTexture(nil, 'BACKGROUND')
	bg:SetGradientAlpha("vertical", 1, 1, 1, 1, 1, 1, 1, 0.4)
	bg:SetWidth(18.3); bg:SetHeight(17)
	bg:SetPoint('CENTER', -0.4, 0.3)
	f.bg = bg
	
	f:SetColor(color.r, color.g, color.b, color.a)
	return f
end

function BongosMinimap:ColorPickerOnClick()

	ColorPickerFrame.func = function()
		local r,g,b = ColorPickerFrame:GetColorRGB()
		local a = 1 - OpacitySliderFrame:GetValue()
		self:SetColor(r,g,b,a)
	end
	
	ColorPickerFrame.hasOpacity = 1
	ColorPickerFrame.opacityFunc = ColorPickerFrame.func
	
	local r, g, b, a = self:GetCheckedTexture():GetVertexColor()
	ColorPickerFrame.opacity = 1 - (a or 0)
	ColorPickerFrame:SetColorRGB(r, g, b)
			
	ColorPickerFrame.cancelFunc = function()
		self:SetColor(r,g,b,a)
	end
	
	ShowUIPanel(ColorPickerFrame)
	self:SetChecked(nil)
end

function BongosMinimap:SetColor(...)
	self.bg:SetTexture(...)
	self:GetCheckedTexture():SetVertexColor(...) --trick to save previous color
	self.func(...)
end


--[[ Button Toggle ]]--

function BongosMinimap:CreateButtonToggle(panel, arg)
	local check = panel:CreateCheckButton(L["Show"..arg])
	check:SetScript("OnShow", function(b) b:SetChecked(self.sets["show"..arg]) end)
	check:SetScript("OnClick", function(b) self.sets["show"..arg] = b:GetChecked() self:ToggleButtons() end)
	return check
end